---
generated_at: 2026-01-30 12:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-Not Found（BlazorWebWasm）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/NotFound.razor`（5行）
- E-02: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Routes.razor`（6行）
- E-03: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Program.cs`（67行）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/not-found` である | E-01（1行目: `@page "/not-found"`） | ○ |
| C-02 | MainLayout を使用 | E-01（2行目: `@layout MainLayout`） | ○ |
| C-03 | 見出しは "Not Found" | E-01（4行目: `<h3>Not Found</h3>`） | ○ |
| C-04 | メッセージは "Sorry, the content you are looking for does not exist." | E-01（5行目: `<p>Sorry, the content...`） | ○ |
| C-05 | Router の NotFoundPage 属性で指定 | E-02（1行目: `NotFoundPage="typeof(Pages.NotFound)"`） | ○ |
| C-06 | UseStatusCodePagesWithReExecute で 404 ハンドリング | E-03（42行目: `app.UseStatusCodePagesWithReExecute("/not-found")`） | ○ |
| C-07 | 関連機能は Mono と WebAssembly Workload | E-05（23行目: 画面No 23 のマッピング） | ○ |
| C-08 | 画面カテゴリは Blazor ページ | E-04（24行目: カテゴリ "Blazor ページ"） | ○ |
| C-09 | 入出力項目なし | E-01（全体: @code ブロックなし） | ○ |
| C-10 | イベント処理なし | E-01（全体: イベントハンドラなし） | ○ |
| C-11 | データベース操作なし | E-01（全体: DB 関連コードなし） | ○ |
| C-12 | 画面遷移図で 404 時の遷移が定義 | E-06（BlazorWebWasm セクション） | ○ |

## 4) 不足情報（Unknown / Missing）

すべての主張に対して根拠が確認できました。不足情報はありません。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に根拠があり、ソースコードと整合しています

## 6) レビュアーチェックリスト（最小）

- [ ] NotFound.razor のコード内容が設計書の記述と一致しているか確認
- [ ] Router の NotFoundPage 設定が正しく機能するか確認
- [ ] UseStatusCodePagesWithReExecute による 404 ハンドリングが正しく動作するか確認
